/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class TitanModifier
extends Modifier
implements ConditionalStatModifierHook {
    private static final Component MINING_SPEED = TConstruct.makeTranslation((String)"modifier", (String)"dwarven.mining_speed");
    private static final Component VELOCITY = TConstruct.makeTranslation((String)"modifier", (String)"dwarven.velocity");
    private static final float BOOST_DISTANCE = 64.0f;
    private static final float DEBUFF_RANGE = 128.0f;
    private static final float MINING_BONUS = 6.0f;
    private static final float VELOCITY_BONUS = 0.05f;

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    private static float getBoost(Level world, float y, int level, float baseSpeed, float modifier, float bonus) {
        if (y > 64.0f) {
            float bonus1 = (y - 64.0f) * bonus / 64.0f * modifier;
            return baseSpeed + bonus1;
        }
        return baseSpeed;
    }

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (!isEffective) {
            return;
        }
        event.setNewSpeed(TitanModifier.getBoost(event.getPlayer().f_19853_, event.getPos().m_123342_(), level, event.getNewSpeed(), miningSpeedModifier * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED), 6.0f));
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.VELOCITY) {
            return TitanModifier.getBoost(living.f_19853_, (float)living.m_20186_(), modifier.getLevel(), baseValue, multiplier, 0.05f);
        }
        return baseValue;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if ((harvest || tool.hasTag(TinkerTags.Items.RANGED)) && player != null && key == TooltipKey.SHIFT) {
            float y = (float)player.m_20186_();
            if (harvest) {
                // empty if block
            }
        }
    }
}

